import Content from "./Content";
import { constructMetadata } from "@/components/utils/seo";
import axios from "axios";
import NotFoundPage from "@/app/[locale]/[...rest]/page";
import { headers } from 'next/headers';

async function getBaseUrl() {
  const headersList = await headers();
  const host = headersList.get('host');
  const protocol = process.env.NODE_ENV === 'development' ? 'http' : 'https';
  
  return `${protocol}://${host}`;
}
const getPageData = async (contentSlug, setStatus) => {
  const baseUrl = await getBaseUrl();
  try {
    const response = await axios.get(`${baseUrl}/data/${ contentSlug }.json`);
    return response.data;
  } catch (error) {
    if (axios.isAxiosError(error)) {
      console.error('Axios Error:', error.response?.status, error.message);
    } else {
      console.error('Unexpected Error:', error);
    }
    return null;
  }
}

export async function generateMetadata({ params }) {
  const { locale, content: slug } = await params;
  const data = await getPageData(slug);

  if (!data) return {};

  const seo = data.seo;
  return constructMetadata({
    title: seo.title[locale||"ar"],
    description: seo.description[locale||"ar"],
    canonicalUrlRelative: `/${locale}/pages/${slug}`,
  });
}

export default async function Page({ params }) {
  const { locale, content: slug } = await params;
  const data = await getPageData(slug);

  if (!data) {
    return <NotFoundPage />;
  }

  return <Content {...data} locale={locale} />;
}